#include "stdafx.h"
#include "common.h"
#include "tree.h"
#include "error.h"
#include "resourcecalc.h"
#include <stdlib.h>
#include "asmutils.h"

//****************************************************************************************************************
//Konstruktor
//****************************************************************************************************************
CResourceCalculations::CResourceCalculations()
{
	m_CurrOffset = -1;
	m_CurrLabel = -1;
	m_CurrLocalsLimit = 0;
	m_CurrNumOfVariables = 0;
}
//****************************************************************************************************************
//Fce pro ziskani cisla dalsi promenne
//****************************************************************************************************************
int CResourceCalculations::Offset()
{
	m_CurrOffset++;
	if (m_CurrOffset > m_CurrLocalsLimit)
		m_CurrLocalsLimit = m_CurrOffset;
	m_CurrNumOfVariables++;

	return m_CurrOffset;
}
//****************************************************************************************************************
//Funkce pro ziskani cisla dalsiho navesti
//****************************************************************************************************************
int CResourceCalculations::Label()
{
	return m_CurrLabel++;
}
//****************************************************************************************************************
//Pruchod skriptem
//****************************************************************************************************************
void CResourceCalculations::Process(SCRIPT* theScript)
{
	if (theScript->toplevels)
		processTOPLEVEL(theScript->toplevels);
}
//****************************************************************************************************************
//Pruchod toplevely
//****************************************************************************************************************
void CResourceCalculations::processTOPLEVEL(TOPLEVEL* toplevel)
{
	processFUNCTION(toplevel->function);

	if (toplevel->next)
		processTOPLEVEL(toplevel->next);
}
//****************************************************************************************************************
//Pruchod fci
//****************************************************************************************************************
void CResourceCalculations::processFUNCTION(FUNCTION* function)
{
	//nastav na vychozi hodnoty pouzite promenne
	m_CurrOffset = -1;				//cislo promenne nastav na -1, protoze vytvoreni cisla jen jen postfix inkrementace
									//teto promenne, az zavolame funkci Offset pro prvni promennou, vrati nam 0 a promenne
									//tak budou cislovany od 0 misto od 1, coz nam usetri misto v zasobniku u virtualniho stroje.
									//Protoze cisla promennych jsou vlastne indexy do zasobniku
	m_CurrLocalsLimit = -1;			//zacina na -1 z podobneho duuvodu jako m_CurrOffset
	m_CurrLabel = 0;
	m_CurrNumOfVariables = 0;

	if (function->kind == localT)		//pocitat zdroje ma cenu jen u lokalni funkce, u ktere zname telo
	{
		if (function->declaration != NULL)
			processDECLARATION(function->declaration);

		if (function->statements != NULL)
			processSTATEMENT(function->statements);
	
		//uloz si pocet navesti a pocet promennych
		function->labelCount = m_CurrLabel;
		function->localsLimit = m_CurrLocalsLimit + 1;	//ulozeni poctu promennych, pouzijeme ve virtualnim stroji k nastaveni BSP
														//a k testu zda nedojde pro volani funkce k preteceni zasobniku

		theLog.TraceF("Function '%s' has %i labels and %i variables. %i variables are visible in main scope.<br>",function->name,function->labelCount,m_CurrNumOfVariables,function->localsLimit);
	}
}
//****************************************************************************************************************
//Pruchod deklaraci
//****************************************************************************************************************
void CResourceCalculations::processDECLARATION(DECLARATION* declaration)
{
	switch (declaration->kind)
	{
	case formalT:
		//vypocti a uloz index promenne
		declaration->val.formalD.offset = Offset();
		break;
	case variableT:
		//vypocti a uloz index promenne
		declaration->val.variableD.offset = Offset();

		if (declaration->val.variableD.initialization != NULL)
			processEXPRESSION(declaration->val.variableD.initialization);
		break;
	case simplevarT:
		//vypocti a uloz index promenne
		declaration->val.simplevarD.offset = Offset();

		if (declaration->val.simplevarD.initialization != NULL)
			processEXPRESSION(declaration->val.simplevarD.initialization);
		break;
	}

	if (declaration->next)
		processDECLARATION(declaration->next);
}
//****************************************************************************************************************
//pruchod incicializaci for cyklu
//****************************************************************************************************************
void CResourceCalculations::processFORINIT(FORINIT* forinit)
{
	switch (forinit->kind)
	{
	case declarationforinitT:
		processDECLARATION(forinit->val.declarationF);
		break;
	case expressionforinitT:
		processEXPRESSION(forinit->val.expressionF);
		break;
	}

	if (forinit->next)
		processFORINIT(forinit->next);
}
//****************************************************************************************************************
//Pruchod jednotlivymi prikazy
//****************************************************************************************************************
void CResourceCalculations::processSTATEMENT(STATEMENT* statement)
{
	int	baseoffset;

	switch (statement->kind)
	{
	case skipT:
		break;
	case expT:
		processEXPRESSION(statement->val.expression);
		break;
	case declstmT:
		processDECLARATION(statement->val.declaration);
		break;
	case returnT:
		if (statement->val.returnS.expression)
			processEXPRESSION(statement->val.returnS.expression);
		break;
	case ifT:
		statement->val.ifS.stoplabel = Label();
		processEXPRESSION(statement->val.ifS.condition);
		processSTATEMENT(statement->val.ifS.body);
		break;
	case ifelseT:
		statement->val.ifelseS.elselabel = Label();
		statement->val.ifelseS.stoplabel = Label();
		processEXPRESSION(statement->val.ifelseS.condition);
		processSTATEMENT(statement->val.ifelseS.ifbody);
		processSTATEMENT(statement->val.ifelseS.elsebody);
		break;
	case forT:
		statement->val.forS.startlabel = Label();
		statement->val.forS.stoplabel = Label();
		processFORINIT(statement->val.forS.inits);
		processEXPRESSION(statement->val.forS.condition);
		processEXPRESSION(statement->val.forS.updates);
		processSTATEMENT(statement->val.forS.body);
		break;
	case whileT:
		statement->val.whileS.startlabel = Label();
		statement->val.whileS.stoplabel = Label();
		processEXPRESSION(statement->val.whileS.condition);
		processSTATEMENT(statement->val.whileS.body);
		break;
	case sequenceT:
		processSTATEMENT(statement->val.sequenceS.firts);
		processSTATEMENT(statement->val.sequenceS.second);
		break;
	case scopeT:
		//mame-li vnoreny prikaz, treba mame for a v {} je jeho telo. V tele for cyklu mohou byt deklarovany
		//promenne ktere plati jen tam, v tele for cyklu. Tim ze si ulozime offset a pote ho zase obnovime docilimke toho, ze
		//se nam spocita opravdu jen ten pocet promennych co ve fci je, a ze dalsi promenne nasledujici po for cyklu
		//mohou prepsat v zasobniku ty z for cyklu, protoze ty stejne uz nepotrebujeme
		baseoffset = m_CurrOffset;	
		processSTATEMENT(statement->val.scopeS.statement);
		m_CurrOffset = baseoffset;
		break;
	}
}
//****************************************************************************************************************
//Pruchod jednotlivymi vyrazy
//****************************************************************************************************************
void CResourceCalculations::processEXPRESSION(EXPRESSION* expression)
{
	if (expression == NULL)
		return;

	switch (expression->kind)
	{
	case intconstT:
		break;
	case stringconstT:
		break;
	case uminusT:
		processEXPRESSION(expression->val.uminusE);
		break;
	case notT:
		expression->val.notE.truelabel = Label();
		expression->val.notE.stoplabel = Label();
		processEXPRESSION(expression->val.notE.expression);
		break;
	case lvalueT:
		break;
	case assignmentT:
		processEXPRESSION(expression->val.assignmentE.right);
		break;
	case plusassignT:
		processEXPRESSION(expression->val.plusassignE.right);
		break;
	case minusassignT:
		processEXPRESSION(expression->val.minusassignE.right);
		break;
	case mulassignT:
		processEXPRESSION(expression->val.mulassignE.right);
		break;
	case divassignT:
		processEXPRESSION(expression->val.divassignE.right);
		break;
	case modassignT:
		processEXPRESSION(expression->val.modassignE.right);
		break;
	case shlassignT:
		processEXPRESSION(expression->val.shlassignE.right);
		break;
	case shrassignT:
		processEXPRESSION(expression->val.shrassignE.right);
		break;
	case andassignT:
		processEXPRESSION(expression->val.andassignE.right);
		break;
	case orassignT:
		processEXPRESSION(expression->val.orassignE.right);
		break;
	case shlT:
		processEXPRESSION(expression->val.shlE.left);
		processEXPRESSION(expression->val.shlE.right);
		break;
	case shrT:
		processEXPRESSION(expression->val.shrE.left);
		processEXPRESSION(expression->val.shrE.right);
		break;
	case bitorT:
		processEXPRESSION(expression->val.bitorE.left);
		processEXPRESSION(expression->val.bitorE.right);
		break;
	case bitandT:
		processEXPRESSION(expression->val.bitandE.left);
		processEXPRESSION(expression->val.bitandE.right);
		break;
	case postincT:
		break;
	case prefincT:
		break;
	case postdecT:
		break;
	case prefdecT:
		break;
	case equalsT:
		expression->val.equalsE.truelabel = Label();
		expression->val.equalsE.stoplabel = Label();
		processEXPRESSION(expression->val.equalsE.left);
		processEXPRESSION(expression->val.equalsE.right);
		break;
	case nequalsT:
		expression->val.nequalsE.truelabel = Label();
		expression->val.nequalsE.stoplabel = Label();
		processEXPRESSION(expression->val.nequalsE.left);
		processEXPRESSION(expression->val.nequalsE.right);
		break;
	case lessT:
		expression->val.lessE.truelabel = Label();
		expression->val.lessE.stoplabel = Label();
		processEXPRESSION(expression->val.lessE.left);
		processEXPRESSION(expression->val.lessE.right);
		break;
	case greaterT:
		expression->val.greaterE.truelabel = Label();
		expression->val.greaterE.stoplabel = Label();
		processEXPRESSION(expression->val.equalsE.left);
		processEXPRESSION(expression->val.equalsE.right);
		break;
	case lequalsT:
		expression->val.lequalsE.truelabel = Label();
		expression->val.lequalsE.stoplabel = Label();
		processEXPRESSION(expression->val.lequalsE.left);
		processEXPRESSION(expression->val.lequalsE.right);
		break;
	case gequalsT:
		expression->val.gequalsE.truelabel = Label();
		expression->val.gequalsE.stoplabel = Label();
		processEXPRESSION(expression->val.gequalsE.left);
		processEXPRESSION(expression->val.gequalsE.right);
		break;
	case plusT:
		processEXPRESSION(expression->val.plusE.left);
		processEXPRESSION(expression->val.plusE.right);
		break;
	case minusT:
		processEXPRESSION(expression->val.minusE.left);
		processEXPRESSION(expression->val.minusE.right);
		break;
	case mulT:
		processEXPRESSION(expression->val.mulE.left);
		processEXPRESSION(expression->val.mulE.right);
		break;
	case divT:
		processEXPRESSION(expression->val.divE.left);
		processEXPRESSION(expression->val.divE.right);
		break;
	case modT:
		processEXPRESSION(expression->val.modE.left);
		processEXPRESSION(expression->val.modE.right);
		break;
	case andT:
		expression->val.andE.falselabel = Label();
		processEXPRESSION(expression->val.andE.left);
		processEXPRESSION(expression->val.andE.right);
		break;
	case orT:
		expression->val.orE.truelabel = Label();
		processEXPRESSION(expression->val.orE.left);
		processEXPRESSION(expression->val.orE.right);
		break;
	case callT:
		if (expression->val.callE.arguments)
			processEXPRESSION(expression->val.callE.arguments);
		break;
	}

	if (expression->next)
		processEXPRESSION(expression->next);
}

